function [filtered_data]=bessel_filter_beta(data,acq_period,cutoff_frequency)

%bessel_filter_beta is an in progress script that filters data at a user
%specified frequency. It is called within the fluorescencewrapper script
%Assign variables
%cutoff_frequency=10000;
Fs=10^6/acq_period;
Wo=2*pi*cutoff_frequency;
%Design a bessel filter with n= order number of filter and Wo=filter
%frequency in rad/s
[b,a]=besself(1,Wo);
figure
freqs(b,a)
[numd, dend]=bilinear(b,a,Fs);
filtered_data=filter(numd,dend,data);


%%%The code below may give the power spectrum of your noise, but it may
%%%also be totally incorrect
[pxx0,f0]=periodogram(data(:,1),[],[],Fs);
[pxx1,f1]=periodogram(filtered_data(:,1),[],[],Fs);
figure
plot(f0,10*log10(pxx0))
hold on
plot(f1,10*log10(pxx1),'r')

